"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksEditorSingleLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _types = require("../../embeddable/types");
var _external_link_tools = require("../external_link/external_link_tools");
var _dashboard_link_tools = require("../dashboard_link/dashboard_link_tools");
var _links_strings = require("../links_strings");
var _dashboard_link_strings = require("../dashboard_link/dashboard_link_strings");
var _content_management = require("../../../common/content_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinksEditorSingleLink = ({
  link,
  editLink,
  deleteLink,
  parentDashboard,
  dragHandleProps
}) => {
  const [destinationError, setDestinationError] = (0, _react.useState)();
  const parentDashboardTitle = parentDashboard === null || parentDashboard === void 0 ? void 0 : parentDashboard.select(state => state.explicitInput.title);
  const parentDashboardId = parentDashboard === null || parentDashboard === void 0 ? void 0 : parentDashboard.select(state => state.componentState.lastSavedId);
  const {
    value: linkLabel,
    loading: linkLabelLoading
  } = (0, _useAsync.default)(async () => {
    if (!link.destination) {
      setDestinationError(new Error(_dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel()));
      return;
    }
    if (link.type === _content_management.DASHBOARD_LINK_TYPE) {
      if (parentDashboardId === link.destination) {
        return link.label || parentDashboardTitle;
      } else {
        const dashboard = await (0, _dashboard_link_tools.fetchDashboard)(link.destination).then(result => {
          setDestinationError(undefined);
          return result;
        }).catch(error => setDestinationError(error));
        return link.label || (dashboard ? dashboard.attributes.title : _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel());
      }
    } else {
      const {
        valid,
        message
      } = (0, _external_link_tools.validateUrl)(link.destination);
      if (!valid && message) {
        setDestinationError(new Error(message));
      }
      return link.label || link.destination;
    }
  }, [link]);
  const LinkLabel = (0, _react.useMemo)(() => {
    const labelText = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      tabIndex: 0,
      gutterSize: "s",
      responsive: false,
      wrap: false,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: destinationError ? 'warning' : _types.LinkInfo[link.type].icon,
      color: destinationError ? 'warning' : 'text',
      "aria-label": destinationError ? _links_strings.LinksStrings.editor.panelEditor.getBrokenDashboardLinkAriaLabel() : _types.LinkInfo[link.type].type
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: (0, _classnames.default)('linksPanelLinkText', {
        'linksPanelLinkText--noLabel': !link.label
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      size: "xxxs",
      isLoading: linkLabelLoading,
      announceLoadedStatus: false,
      announceLoadingStatus: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: 'default',
      className: "eui-textTruncate"
    }, linkLabel))));
    return () => destinationError ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: destinationError.message,
      title: link.type === _content_management.DASHBOARD_LINK_TYPE ? _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel() : undefined // the messages thrown by an invalid URL are clear enough without an extra title
    }, labelText) : labelText;
  }, [linkLabel, linkLabelLoading, destinationError, link.label, link.type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    color: destinationError ? 'warning' : 'plain',
    className: `linksPanelLink ${destinationError ? 'linkError' : ''}`,
    "data-test-subj": `panelEditorLink${linkLabelLoading ? '--loading' : ''}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "none"
  }, dragHandleProps, {
    "aria-label": _links_strings.LinksStrings.editor.panelEditor.getDragHandleAriaLabel(),
    "data-test-subj": "panelEditorLink--dragHandle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "linksPanelLinkText"
  }, /*#__PURE__*/_react.default.createElement(LinkLabel, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    className: "links_hoverActions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _links_strings.LinksStrings.editor.getEditLinkTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "pencil",
    onClick: editLink,
    "aria-label": _links_strings.LinksStrings.editor.getEditLinkTitle(),
    "data-test-subj": "panelEditorLink--editBtn"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _links_strings.LinksStrings.editor.getDeleteLinkTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "trash",
    "aria-label": _links_strings.LinksStrings.editor.getDeleteLinkTitle(),
    color: "danger",
    onClick: deleteLink,
    "data-test-subj": "panelEditorLink--deleteBtn"
  })))))));
};
exports.LinksEditorSingleLink = LinksEditorSingleLink;