"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkDestination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _content_management = require("../../../common/content_management");
var _external_link_destination_picker = require("../external_link/external_link_destination_picker");
var _dashboard_link_destination_picker = require("../dashboard_link/dashboard_link_destination_picker");
var _links_strings = require("../links_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinkDestination = ({
  link,
  setDestination,
  parentDashboard,
  selectedLinkType
}) => {
  const [destinationError, setDestinationError] = (0, _react.useState)();

  /**
   * Store the dashboard / external destinations separately so that we can remember the selections
   * made in each component even when the selected link type changes
   */
  const [dashboardLinkDestination, setDashboardLinkDestination] = (0, _react.useState)(link && link.type === _content_management.DASHBOARD_LINK_TYPE ? link.destination : undefined);
  const [externalLinkDestination, setExternalLinkDestination] = (0, _react.useState)(link && link.type === _content_management.EXTERNAL_LINK_TYPE ? link.destination : undefined);
  const isInvalid = Boolean(destinationError);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: destinationError,
    isInvalid: isInvalid,
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkDestinationLabel(),
    "data-test-subj": `links--linkDestination${isInvalid ? '--error' : ''}`
  }, selectedLinkType === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_destination_picker.DashboardLinkDestinationPicker, {
    onUnmount: selectedDashboardId => {
      setDestination(undefined, undefined);
      if (selectedDashboardId) setDashboardLinkDestination(selectedDashboardId);
    },
    parentDashboard: parentDashboard,
    initialSelection: dashboardLinkDestination,
    onDestinationPicked: dashboard => setDestination(dashboard === null || dashboard === void 0 ? void 0 : dashboard.id, dashboard === null || dashboard === void 0 ? void 0 : dashboard.attributes.title)
  }) : /*#__PURE__*/_react.default.createElement(_external_link_destination_picker.ExternalLinkDestinationPicker, {
    onUnmount: selectedUrl => {
      setDestinationError(undefined);
      setDestination(undefined, undefined);
      if (selectedUrl) setExternalLinkDestination(selectedUrl);
    },
    initialSelection: externalLinkDestination,
    onDestinationPicked: url => setDestination(url, url),
    setDestinationError: setDestinationError
  }));
};
exports.LinkDestination = LinkDestination;