"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPLOAD_LICENSE_ROUTE = exports.LicenseManagementLocatorDefinition = exports.LICENSE_MANAGEMENT_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LICENSE_MANAGEMENT_LOCATOR_ID = 'LICENSE_MANAGEMENT_LOCATOR';
exports.LICENSE_MANAGEMENT_LOCATOR_ID = LICENSE_MANAGEMENT_LOCATOR_ID;
const UPLOAD_LICENSE_ROUTE = 'upload_license';
exports.UPLOAD_LICENSE_ROUTE = UPLOAD_LICENSE_ROUTE;
class LicenseManagementLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", LICENSE_MANAGEMENT_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const location = await this.deps.managementAppLocator.getLocation({
        sectionId: 'stack',
        appId: _constants.PLUGIN.id
      });
      switch (params.page) {
        case 'upload_license':
          {
            return {
              ...location,
              path: `${location.path}/${UPLOAD_LICENSE_ROUTE}`
            };
          }
        case 'dashboard':
          {
            return location;
          }
      }
    });
    this.deps = deps;
  }
}
exports.LicenseManagementLocatorDefinition = LicenseManagementLocatorDefinition;