"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.permissions = void 0;
var _reduxActions = require("redux-actions");
var _permissions = require("../actions/permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const permissions = (0, _reduxActions.handleActions)({
  [_permissions.permissionsLoading](state, {
    payload
  }) {
    return {
      loading: payload
    };
  },
  [_permissions.permissionsSuccess](state, {
    payload
  }) {
    return {
      hasPermission: payload
    };
  },
  [_permissions.permissionsError](state, {
    payload
  }) {
    return {
      error: payload
    };
  }
}, {});
exports.permissions = permissions;