"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _shared_imports = require("../shared_imports");
var _app_context = require("./app_context");
var _store = require("./store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const AppProviders = ({
  appDependencies,
  children
}) => {
  const {
    core,
    plugins,
    services,
    store: {
      initialLicense
    },
    theme$
  } = appDependencies;
  const {
    http,
    notifications: {
      toasts
    },
    i18n: {
      Context: I18nContext
    }
  } = core;

  // Setup Redux store
  const thunkServices = {
    history: appDependencies.services.history,
    toasts,
    http,
    telemetry: plugins.telemetry,
    licensing: plugins.licensing,
    breadcrumbService: services.breadcrumbService
  };
  const initialState = {
    license: initialLicense
  };
  const store = (0, _store.licenseManagementStore)(initialState, thunkServices);
  return /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: appDependencies
  }, children))));
};
exports.AppProviders = AppProviders;