"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XyVisualization = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/charts-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class XyVisualization {
  setup(core, {
    editorFrame
  }) {
    editorFrame.registerVisualization(async () => {
      const {
        getXyVisualization
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
      const [coreStart, {
        charts,
        data,
        fieldFormats,
        eventAnnotation,
        unifiedSearch,
        savedObjectsTagging,
        dataViews
      }] = await core.getStartServices();
      const [palettes, eventAnnotationService] = await Promise.all([charts.palettes.getPalettes(), eventAnnotation.getService()]);
      const useLegacyTimeAxis = core.uiSettings.get(_common.LEGACY_TIME_AXIS);
      return getXyVisualization({
        core: coreStart,
        data,
        storage: new _public.Storage(localStorage),
        paletteService: palettes,
        eventAnnotationService,
        fieldFormats,
        useLegacyTimeAxis,
        kibanaTheme: core.theme,
        unifiedSearch,
        dataViewsService: dataViews,
        savedObjectsTagging
      });
    });
  }
}
exports.XyVisualization = XyVisualization;