"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revert = exports.getRevertChangesAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _state_helpers = require("../../state_helpers");
var _visualization_helpers = require("../../visualization_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRevertChangesAction = ({
  state,
  layer,
  setState,
  core
}) => {
  return {
    displayName: _i18n.i18n.translate('xpack.lens.xyChart.annotations.revertChanges', {
      defaultMessage: 'Revert changes'
    }),
    description: _i18n.i18n.translate('xpack.lens.xyChart.annotations.revertChangesDescription', {
      defaultMessage: 'Restores annotation group to the last saved state.'
    }),
    execute: async () => {
      const modal = core.overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(RevertChangesConfirmModal, {
        modalTitle: _i18n.i18n.translate('xpack.lens.modalTitle.revertAnnotationGroupTitle', {
          defaultMessage: 'Revert "{title}" changes?',
          values: {
            title: (0, _visualization_helpers.getAnnotationLayerTitle)(layer)
          }
        }),
        onCancel: () => modal.close(),
        onConfirm: () => {
          revert({
            setState,
            layer,
            state,
            modal,
            toasts: core.notifications.toasts
          });
        }
      }), {
        theme$: core.theme.theme$
      }), {
        'data-test-subj': 'lnsAnnotationLayerRevertModal',
        maxWidth: 600
      });
      await modal.onClose;
    },
    icon: 'editorUndo',
    isCompatible: true,
    disabled: !(0, _state_helpers.annotationLayerHasUnsavedChanges)(layer),
    'data-test-subj': 'lnsXY_annotationLayer_revertChanges',
    order: 200
  };
};
exports.getRevertChangesAction = getRevertChangesAction;
const revert = ({
  setState,
  layer,
  state,
  modal,
  toasts
}) => {
  const newLayer = {
    layerId: layer.layerId,
    layerType: layer.layerType,
    annotationGroupId: layer.annotationGroupId,
    indexPatternId: layer.__lastSaved.indexPatternId,
    ignoreGlobalFilters: layer.__lastSaved.ignoreGlobalFilters,
    annotations: (0, _lodash.cloneDeep)(layer.__lastSaved.annotations),
    __lastSaved: layer.__lastSaved
  };
  setState({
    ...state,
    layers: state.layers.map(layerToCheck => layerToCheck.layerId === layer.layerId ? newLayer : layerToCheck)
  });
  modal.close();
  toasts.addSuccess({
    title: _i18n.i18n.translate('xpack.lens.xyChart.annotations.notificationReverted', {
      defaultMessage: `Reverted "{title}"`,
      values: {
        title: (0, _visualization_helpers.getAnnotationLayerTitle)(layer)
      }
    }),
    text: _i18n.i18n.translate('xpack.lens.xyChart.annotations.notificationRevertedExplanation', {
      defaultMessage: 'The most recently saved version of this annotation group has been restored.'
    })
  });
};
exports.revert = revert;
const RevertChangesConfirmModal = ({
  modalTitle,
  onConfirm,
  onCancel
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, modalTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.lens.layer.revertModal.revertAnnotationGroupDescription', {
    defaultMessage: `This action will remove all unsaved changes that you've made and restore the most recent saved version of this annotation group to you visualization. Any lost unsaved changes cannot be restored.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel
  }, _i18n.i18n.translate('xpack.lens.layer.cancelDelete', {
    defaultMessage: `Cancel`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "lnsLayerRevertChangesButton",
    onClick: onConfirm,
    color: "warning",
    iconType: "returnKey",
    fill: true
  }, _i18n.i18n.translate('xpack.lens.layer.unlinkConfirm', {
    defaultMessage: 'Revert changes'
  }))))))));
};