"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PieToolbar = PieToolbar;
require("./toolbar.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _constants = require("./constants");
var _partition_charts_meta = require("./partition_charts_meta");
var _constants2 = require("../../../common/constants");
var _shared_components = require("../../shared_components");
var _datasource_default_values = require("../../shared_components/datasource_default_values");
var _render_helpers = require("./render_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const legendOptions = [{
  id: 'pieLegendDisplay-default',
  value: _constants2.LegendDisplay.DEFAULT,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.auto', {
    defaultMessage: 'Auto'
  })
}, {
  id: 'pieLegendDisplay-show',
  value: _constants2.LegendDisplay.SHOW,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: 'pieLegendDisplay-hide',
  value: _constants2.LegendDisplay.HIDE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const emptySizeRatioLabel = _i18n.i18n.translate('xpack.lens.pieChart.emptySizeRatioLabel', {
  defaultMessage: 'Inner area size'
});
function PieToolbar(props) {
  var _layer$percentDecimal, _emptySizeRatioOption2, _emptySizeRatioOption3, _ref, _PartitionChartsMeta$, _PartitionChartsMeta$2, _layer$secondaryGroup, _layer$secondaryGroup2, _layer$truncateLegend2;
  const {
    state,
    setState,
    frame
  } = props;
  const layer = state.layers[0];
  const {
    categoryOptions,
    numberOptions,
    emptySizeRatioOptions,
    isDisabled: isToolbarPopoverDisabled
  } = _partition_charts_meta.PartitionChartsMeta[state.shape].toolbarPopover;
  const legendSize = layer.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _public.LegendSize.AUTO);
  const onStateChange = (0, _react.useCallback)(part => {
    setState({
      ...state,
      layers: [{
        ...layer,
        ...part
      }]
    });
  }, [layer, state, setState]);
  const onCategoryDisplayChange = (0, _react.useCallback)(option => onStateChange({
    categoryDisplay: option
  }), [onStateChange]);
  const onNumberDisplayChange = (0, _react.useCallback)(option => onStateChange({
    numberDisplay: option
  }), [onStateChange]);
  const onPercentDecimalsChange = (0, _react.useCallback)(option => {
    onStateChange({
      percentDecimals: option
    });
  }, [onStateChange]);
  const onLegendDisplayChange = (0, _react.useCallback)(optionId => {
    onStateChange({
      legendDisplay: legendOptions.find(({
        id
      }) => id === optionId).value
    });
  }, [onStateChange]);
  const onLegendPositionChange = (0, _react.useCallback)(id => onStateChange({
    legendPosition: id
  }), [onStateChange]);
  const onNestedLegendChange = (0, _react.useCallback)(id => onStateChange({
    nestedLegend: !layer.nestedLegend
  }), [layer, onStateChange]);
  const onTruncateLegendChange = (0, _react.useCallback)(() => {
    var _layer$truncateLegend;
    const current = (_layer$truncateLegend = layer.truncateLegend) !== null && _layer$truncateLegend !== void 0 ? _layer$truncateLegend : true;
    onStateChange({
      truncateLegend: !current
    });
  }, [layer, onStateChange]);
  const onLegendMaxLinesChange = (0, _react.useCallback)(val => onStateChange({
    legendMaxLines: val
  }), [onStateChange]);
  const onLegendSizeChange = (0, _react.useCallback)(val => onStateChange({
    legendSize: val
  }), [onStateChange]);
  const onValueInLegendChange = (0, _react.useCallback)(() => {
    onStateChange({
      showValuesInLegend: !(0, _render_helpers.shouldShowValuesInLegend)(layer, state.shape)
    });
  }, [layer, state.shape, onStateChange]);
  const onEmptySizeRatioChange = (0, _react.useCallback)(sizeId => {
    var _emptySizeRatioOption;
    const emptySizeRatio = emptySizeRatioOptions === null || emptySizeRatioOptions === void 0 ? void 0 : (_emptySizeRatioOption = emptySizeRatioOptions.find(({
      id
    }) => id === sizeId)) === null || _emptySizeRatioOption === void 0 ? void 0 : _emptySizeRatioOption.value;
    onStateChange({
      emptySizeRatio
    });
  }, [emptySizeRatioOptions, onStateChange]);
  if (!layer) {
    return null;
  }
  const defaultTruncationValue = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.pieChart.valuesLabel', {
      defaultMessage: 'Labels'
    }),
    isDisabled: Boolean(isToolbarPopoverDisabled),
    type: "labels",
    groupPosition: "left",
    buttonDataTestSubj: "lnsLabelsButton"
  }, categoryOptions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.labelPositionLabel', {
      defaultMessage: 'Position'
    }),
    fullWidth: true,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    valueOfSelected: layer.categoryDisplay,
    options: categoryOptions,
    onChange: onCategoryDisplayChange
  })) : null, numberOptions.length && layer.categoryDisplay !== 'hide' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.numberLabels', {
      defaultMessage: 'Values'
    }),
    fullWidth: true,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    valueOfSelected: layer.numberDisplay,
    options: numberOptions,
    onChange: onNumberDisplayChange
  })) : null, numberOptions.length + categoryOptions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.percentDecimalsLabel', {
      defaultMessage: 'Maximum decimal places for percent'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(DecimalPlaceSlider, {
    value: (_layer$percentDecimal = layer.percentDecimals) !== null && _layer$percentDecimal !== void 0 ? _layer$percentDecimal : _constants.DEFAULT_PERCENT_DECIMALS,
    setValue: onPercentDecimalsChange
  }))), emptySizeRatioOptions !== null && emptySizeRatioOptions !== void 0 && emptySizeRatioOptions.length ? /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.pieChart.visualOptionsLabel', {
      defaultMessage: 'Visual options'
    }),
    type: "visualOptions",
    groupPosition: "center",
    buttonDataTestSubj: "lnsVisualOptionsButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: emptySizeRatioLabel,
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    name: "emptySizeRatio",
    buttonSize: "compressed",
    legend: emptySizeRatioLabel,
    options: emptySizeRatioOptions,
    idSelected: (_emptySizeRatioOption2 = (_emptySizeRatioOption3 = emptySizeRatioOptions.find(({
      value
    }) => value === layer.emptySizeRatio)) === null || _emptySizeRatioOption3 === void 0 ? void 0 : _emptySizeRatioOption3.id) !== null && _emptySizeRatioOption2 !== void 0 ? _emptySizeRatioOption2 : 'emptySizeRatioOption-small',
    onChange: onEmptySizeRatioChange,
    "data-test-subj": "lnsEmptySizeRatioButtonGroup"
  }))) : null, /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettingsPopover, {
    legendOptions: legendOptions,
    mode: layer.legendDisplay,
    onDisplayChange: onLegendDisplayChange,
    valueInLegend: (0, _render_helpers.shouldShowValuesInLegend)(layer, state.shape),
    renderValueInLegendSwitch: (_ref = 'showValues' in ((_PartitionChartsMeta$ = _partition_charts_meta.PartitionChartsMeta[state.shape]) === null || _PartitionChartsMeta$ === void 0 ? void 0 : _PartitionChartsMeta$.legend)) !== null && _ref !== void 0 ? _ref : false,
    onValueInLegendChange: onValueInLegendChange,
    position: layer.legendPosition,
    onPositionChange: onLegendPositionChange,
    renderNestedLegendSwitch: !((_PartitionChartsMeta$2 = _partition_charts_meta.PartitionChartsMeta[state.shape]) !== null && _PartitionChartsMeta$2 !== void 0 && _PartitionChartsMeta$2.legend.hideNestedLegendSwitch) && layer.primaryGroups.length + ((_layer$secondaryGroup = (_layer$secondaryGroup2 = layer.secondaryGroups) === null || _layer$secondaryGroup2 === void 0 ? void 0 : _layer$secondaryGroup2.length) !== null && _layer$secondaryGroup !== void 0 ? _layer$secondaryGroup : 0) > 1,
    nestedLegend: Boolean(layer.nestedLegend),
    onNestedLegendChange: onNestedLegendChange,
    shouldTruncate: (_layer$truncateLegend2 = layer.truncateLegend) !== null && _layer$truncateLegend2 !== void 0 ? _layer$truncateLegend2 : defaultTruncationValue,
    onTruncateLegendChange: onTruncateLegendChange,
    maxLines: layer === null || layer === void 0 ? void 0 : layer.legendMaxLines,
    onMaxLinesChange: onLegendMaxLinesChange,
    legendSize: legendSize,
    onLegendSizeChange: onLegendSizeChange,
    showAutoLegendSizeOption: hadAutoLegendSize
  }));
}
const DecimalPlaceSlider = ({
  value,
  setValue
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUiComponents.useDebouncedValue)({
    value,
    onChange: setValue
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    "data-test-subj": "indexPattern-dimension-formatDecimals",
    value: inputValue,
    min: 0,
    max: 10,
    showInput: true,
    compressed: true,
    onChange: e => {
      handleInputChange(Number(e.currentTarget.value));
    }
  });
};