"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowValuesInLegend = exports.checkTableForContainsSmallValues = void 0;
var _partition_charts_meta = require("./partition_charts_meta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shouldShowValuesInLegend = (layer, shape) => {
  var _PartitionChartsMeta$;
  if ('showValues' in ((_PartitionChartsMeta$ = _partition_charts_meta.PartitionChartsMeta[shape]) === null || _PartitionChartsMeta$ === void 0 ? void 0 : _PartitionChartsMeta$.legend)) {
    var _ref, _layer$showValuesInLe, _PartitionChartsMeta$2, _PartitionChartsMeta$3;
    return (_ref = (_layer$showValuesInLe = layer.showValuesInLegend) !== null && _layer$showValuesInLe !== void 0 ? _layer$showValuesInLe : (_PartitionChartsMeta$2 = _partition_charts_meta.PartitionChartsMeta[shape]) === null || _PartitionChartsMeta$2 === void 0 ? void 0 : (_PartitionChartsMeta$3 = _PartitionChartsMeta$2.legend) === null || _PartitionChartsMeta$3 === void 0 ? void 0 : _PartitionChartsMeta$3.showValues) !== null && _ref !== void 0 ? _ref : true;
  }
  return false;
};
exports.shouldShowValuesInLegend = shouldShowValuesInLegend;
const checkTableForContainsSmallValues = (dataTable, columnId, minPercentage) => {
  const overallSum = dataTable.rows.reduce((partialSum, row) => Number(row[columnId]) + partialSum, 0);
  return dataTable.rows.some(row => row[columnId] / overallSum * 100 < minPercentage);
};
exports.checkTableForContainsSmallValues = checkTableForContainsSmallValues;