"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = getSuggestions;
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/expression-xy-plugin/public");
var _visualization = require("./visualization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generate suggestions for the metric chart.
 *
 * @param opts
 */
function getSuggestions({
  table,
  state,
  keptLayerIds,
  datasourceId
}) {
  // We only render metric charts for single-row queries. We require a single, numeric column.
  if (table.isMultiRow || keptLayerIds.length > 1 || keptLayerIds.length && table.layerId !== keptLayerIds[0] || table.columns.length !== 1 || table.columns[0].operation.isBucketed || !_visualization.legacyMetricSupportedTypes.has(table.columns[0].operation.dataType) || table.columns[0].operation.isStaticValue) {
    return [];
  }

  // don't suggest current table if visualization is active
  if (state && table.changeType === 'unchanged') {
    return [];
  }

  // do not return the legacy metric vis for the textbased mode (i.e. ES|QL)
  if (datasourceId === 'textBased') {
    return [];
  }
  return [getSuggestion(table)];
}
function getSuggestion(table) {
  const col = table.columns[0];
  const title = table.label || col.operation.label;
  return {
    title,
    score: 0.1,
    previewIcon: _chartIcons.IconChartMetric,
    state: {
      layerId: table.layerId,
      accessor: col.columnId,
      layerType: _public.LayerTypes.DATA
    }
  };
}