"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapDimensionEditor = HeatmapDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _shared_components = require("../../shared_components");
require("./dimension_editor.scss");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeatmapDimensionEditor(props) {
  var _frame$activeData;
  const {
    state,
    setState,
    frame,
    accessor,
    isInlineEditing
  } = props;
  const [isPaletteOpen, setIsPaletteOpen] = (0, _react.useState)(false);
  if ((state === null || state === void 0 ? void 0 : state.valueAccessor) !== accessor) return null;
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];

  // need to tell the helper that the colorStops are required to display
  const {
    displayStops,
    activePalette,
    currentMinMax
  } = (0, _utils.getSafePaletteParams)(props.paletteService, currentData, accessor, state !== null && state !== void 0 && state.palette && state.palette.accessor === accessor ? state.palette : undefined);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "lnsDynamicColoringRow",
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.paletteHeatmapGradient.label', {
      defaultMessage: 'Color'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    className: "lnsDynamicColoringClickable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    "data-test-subj": "lnsHeatmap_dynamicColoring_palette",
    palette: displayStops.map(({
      color
    }) => color),
    type: _coloring.FIXED_PROGRESSION,
    onClick: () => {
      setIsPaletteOpen(!isPaletteOpen);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "lnsHeatmap_dynamicColoring_trigger",
    "aria-label": _i18n.i18n.translate('xpack.lens.paletteHeatmapGradient.customizeLong', {
      defaultMessage: 'Edit palette'
    }),
    iconType: "controlsHorizontal",
    onClick: () => {
      setIsPaletteOpen(!isPaletteOpen);
    },
    size: "xs",
    flush: "both"
  }, _i18n.i18n.translate('xpack.lens.paletteHeatmapGradient.customize', {
    defaultMessage: 'Edit'
  })), /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    siblingRef: props.panelRef,
    isOpen: isPaletteOpen,
    handleClose: () => setIsPaletteOpen(!isPaletteOpen),
    title: _i18n.i18n.translate('xpack.lens.table.colorByRangePanelTitle', {
      defaultMessage: 'Color'
    }),
    isInlineEditing: isInlineEditing
  }, activePalette && /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: props.paletteService,
    activePalette: activePalette,
    dataBounds: currentMinMax,
    setPalette: newPalette => {
      // make sure to always have a list of stops
      if (newPalette.params && !newPalette.params.stops) {
        newPalette.params.stops = displayStops;
      }
      newPalette.accessor = accessor;
      setState({
        ...state,
        palette: newPalette
      });
    }
  }))))));
}