"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnCellValueActions = getColumnCellValueActions;
exports.getDatatableRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _table_basic = require("./components/table_basic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getColumnsFilterable(table, handlers) {
  if (!table.rows.length) {
    return;
  }
  return Promise.all(table.columns.map(async (column, colIndex) => {
    var _handlers$hasCompatib;
    return Boolean(await ((_handlers$hasCompatib = handlers.hasCompatibleActions) === null || _handlers$hasCompatib === void 0 ? void 0 : _handlers$hasCompatib.call(handlers, {
      name: 'filter',
      data: {
        data: [{
          table,
          column: colIndex,
          row: 0
        }]
      }
    })));
  }));
}

/**
 * Retrieves the compatible CELL_VALUE_TRIGGER actions indexed by column
 **/
async function getColumnCellValueActions(config, getCompatibleCellValueActions) {
  if (!config.data || !getCompatibleCellValueActions) {
    return [];
  }
  return Promise.all(config.data.columns.map(({
    meta: columnMeta
  }) => {
    try {
      return getCompatibleCellValueActions([{
        columnMeta
      }]);
    } catch {
      return [];
    }
  }));
}
const getDatatableRenderer = dependencies => ({
  name: 'lens_datatable_renderer',
  displayName: _i18n.i18n.translate('xpack.lens.datatable.visualizationName', {
    defaultMessage: 'Datatable'
  }),
  help: '',
  validate: () => undefined,
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    handlers.onDestroy(() => _reactDom.default.unmountComponentAtNode(domNode));
    const resolvedGetType = await dependencies.getType;
    const {
      hasCompatibleActions,
      isInteractive,
      getCompatibleCellValueActions
    } = handlers;
    const renderComplete = () => {
      (0, _lens_ui_telemetry.trackUiCounterEvents)('table', handlers.getExecutionContext());
      handlers.done();
    };

    // An entry for each table row, whether it has any actions attached to
    // ROW_CLICK_TRIGGER trigger.
    let rowHasRowClickTriggerActions = [];
    if (hasCompatibleActions) {
      if (!!config.data) {
        rowHasRowClickTriggerActions = await Promise.all(config.data.rows.map(async (row, rowIndex) => {
          try {
            const hasActions = await hasCompatibleActions({
              name: 'tableRowContextMenuClick',
              data: {
                rowIndex,
                table: config.data,
                columns: config.args.columns.map(column => column.columnId)
              }
            });
            return hasActions;
          } catch {
            return false;
          }
        }));
      }
    }
    const [columnCellValueActions, columnsFilterable] = await Promise.all([getColumnCellValueActions(config, getCompatibleCellValueActions), getColumnsFilterable(config.data, handlers)]);
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: dependencies.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_table_basic.DatatableComponent, (0, _extends2.default)({}, config, {
      formatFactory: dependencies.formatFactory,
      dispatchEvent: handlers.event,
      renderMode: handlers.getRenderMode(),
      paletteService: dependencies.paletteService,
      getType: resolvedGetType,
      rowHasRowClickTriggerActions: rowHasRowClickTriggerActions,
      columnCellValueActions: columnCellValueActions,
      columnFilterable: columnsFilterable,
      interactive: isInteractive(),
      theme: dependencies.theme,
      renderComplete: renderComplete
    })))), domNode);
  }
});
exports.getDatatableRenderer = getDatatableRenderer;