"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigureLensHelpersAsync = exports.ConfigureInLensPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const ACTION_CONFIGURE_IN_LENS = 'ACTION_CONFIGURE_IN_LENS';
const getConfigureLensHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
exports.getConfigureLensHelpersAsync = getConfigureLensHelpersAsync;
class ConfigureInLensPanelAction {
  constructor(startDependencies, overlays, theme) {
    (0, _defineProperty2.default)(this, "type", ACTION_CONFIGURE_IN_LENS);
    (0, _defineProperty2.default)(this, "id", ACTION_CONFIGURE_IN_LENS);
    (0, _defineProperty2.default)(this, "order", 50);
    this.startDependencies = startDependencies;
    this.overlays = overlays;
    this.theme = theme;
  }
  getDisplayName({
    embeddable
  }) {
    const language = (0, _utils.isLensEmbeddable)(embeddable) ? embeddable.getTextBasedLanguage() : undefined;
    return _i18n.i18n.translate('xpack.lens.app.editVisualizationLabel', {
      defaultMessage: 'Edit {lang} visualization',
      values: {
        lang: language
      }
    });
  }
  getIconType() {
    return 'pencil';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      isActionCompatible
    } = await getConfigureLensHelpersAsync();
    return isActionCompatible(embeddable);
  }
  async execute({
    embeddable
  }) {
    const {
      executeAction
    } = await getConfigureLensHelpersAsync();
    return executeAction({
      embeddable,
      startDependencies: this.startDependencies,
      overlays: this.overlays,
      theme: this.theme
    });
  }
}
exports.ConfigureInLensPanelAction = ConfigureInLensPanelAction;