"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarPopover = void 0;
require("./toolbar_popover.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _chartIcons = require("@kbn/chart-icons");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const typeToIconMap = {
  legend: _chartIcons.EuiIconLegend,
  labels: 'visText',
  values: 'number',
  list: 'list',
  visualOptions: 'brush'
};
const ToolbarPopover = ({
  children,
  title,
  type,
  isDisabled = false,
  groupPosition,
  buttonDataTestSubj,
  panelClassName = 'lnsVisToolbar__popover',
  handleClose
}) => {
  const [open, setOpen] = (0, _react.useState)(false);
  const iconType = typeof type === 'string' ? typeToIconMap[type] : type;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelClassName: panelClassName,
    ownFocus: true,
    "aria-label": title,
    button: /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      as: 'iconButton',
      iconType: iconType,
      onClick: () => {
        setOpen(!open);
      },
      "aria-label": title,
      isDisabled: isDisabled,
      groupPosition: groupPosition,
      "data-test-subj": buttonDataTestSubj
    }),
    isOpen: open,
    closePopover: () => {
      setOpen(false);
      handleClose === null || handleClose === void 0 ? void 0 : handleClose();
    },
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, title), children));
};
exports.ToolbarPopover = ToolbarPopover;