"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyPaletteParams = applyPaletteParams;
exports.findMinMaxByColumnId = void 0;
exports.getContrastColor = getContrastColor;
exports.getNumericValue = getNumericValue;
var _uiTheme = require("@kbn/ui-theme");
var _coloring = require("@kbn/coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getContrastColor(color, isDarkTheme, darkTextProp = 'euiColorInk', lightTextProp = 'euiColorGhost') {
  // when in light theme both text color and colorInk are dark and the choice
  // may depends on the specific context.
  const darkColor = isDarkTheme ? _uiTheme.euiDarkVars.euiColorInk : _uiTheme.euiLightVars[darkTextProp];
  // Same thing for light color in dark theme
  const lightColor = isDarkTheme ? _uiTheme.euiDarkVars[lightTextProp] : _uiTheme.euiLightVars.euiColorGhost;
  const backgroundColor = isDarkTheme ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor;
  return (0, _coloring.enforceColorContrast)(color, backgroundColor) ? lightColor : darkColor;
}
function getNumericValue(rowValue) {
  if (rowValue == null || Array.isArray(rowValue)) {
    return;
  }
  return rowValue;
}
function applyPaletteParams(palettes, activePalette, dataBounds) {
  var _activePalette$params, _activePalette$params2;
  // make a copy of it as they have to be manipulated later on
  const displayStops = (0, _coloring.getPaletteStops)(palettes, (activePalette === null || activePalette === void 0 ? void 0 : activePalette.params) || {}, {
    dataBounds,
    defaultPaletteName: activePalette === null || activePalette === void 0 ? void 0 : activePalette.name
  });
  if (activePalette !== null && activePalette !== void 0 && (_activePalette$params = activePalette.params) !== null && _activePalette$params !== void 0 && _activePalette$params.reverse && (activePalette === null || activePalette === void 0 ? void 0 : (_activePalette$params2 = activePalette.params) === null || _activePalette$params2 === void 0 ? void 0 : _activePalette$params2.name) !== _coloring.CUSTOM_PALETTE) {
    return (0, _coloring.reversePalette)(displayStops);
  }
  return displayStops;
}
const findMinMaxByColumnId = (columnIds, table, getOriginalId = id => id) => {
  const minMax = {};
  if (table != null) {
    for (const columnId of columnIds) {
      const originalId = getOriginalId(columnId);
      minMax[originalId] = minMax[originalId] || {
        max: Number.NEGATIVE_INFINITY,
        min: Number.POSITIVE_INFINITY
      };
      table.rows.forEach(row => {
        const rowValue = row[columnId];
        const numericValue = getNumericValue(rowValue);
        if (numericValue != null) {
          if (minMax[originalId].min > numericValue) {
            minMax[originalId].min = numericValue;
          }
          if (minMax[originalId].max < numericValue) {
            minMax[originalId].max = numericValue;
          }
        }
      });
      // what happens when there's no data in the table? Fallback to a percent range
      if (minMax[originalId].max === Number.NEGATIVE_INFINITY) {
        minMax[originalId] = (0, _coloring.getFallbackDataBounds)();
      }
    }
  }
  return minMax;
};
exports.findMinMaxByColumnId = findMinMaxByColumnId;