"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elastic_elk_b = _interopRequireDefault(require("./elastic_elk_b.png"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Bee() {
  const [position, setPosition] = (0, _react.useState)({
    top: 50 + Math.random() * 100,
    left: 50 + Math.random() * 50,
    vX: 3 + Math.random(),
    vY: 0.5 + Math.random() * 0.5
  });
  (0, _react.useEffect)(() => {
    let handle = 0;
    function tick() {
      handle = requestAnimationFrame(() => {
        setPosition(({
          top,
          left,
          vX,
          vY
        }) => {
          let newVx = vX + Math.random() * 0.5 - 0.25;
          let newVy = vY + Math.random() - 0.5;
          if (top < 50) {
            newVy = Math.abs(newVy);
          }
          if (top > window.innerHeight - 300) {
            newVy = -1 * Math.abs(newVy);
          }
          if (left < 50) {
            newVx = Math.abs(newVx);
          }
          if (left > window.innerWidth - 300) {
            newVx = -1 * Math.abs(newVx);
          }
          return {
            top: top + vY,
            left: left + vX,
            vX: newVx,
            vY: newVy
          };
        });
        tick();
      });
    }
    tick();
    return () => {
      cancelAnimationFrame(handle);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("img", {
    src: _elastic_elk_b.default,
    alt: "ELK-Bee",
    title: "Bzzzzzzz",
    style: {
      position: 'absolute',
      width: '80px',
      height: 'auto',
      transform: position.vX > 0 ? 'scale(-1, 1)' : undefined,
      top: position.top,
      left: position.left,
      zIndex: 999
    }
  });
}

// eslint-disable-next-line import/no-default-export
var _default = Bee;
exports.default = _default;
module.exports = exports.default;