"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDropProps = void 0;
var _types = require("../../../types");
var _utils = require("../../../utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDropProps = props => {
  const {
    source,
    target,
    state
  } = props;
  if (!source || source.id === target.columnId) {
    return;
  }
  const layer = state.layers[target.layerId];
  const targetColumn = layer.columns.find(f => f.columnId === target.columnId);
  const targetField = layer.allColumns.find(f => f.columnId === target.columnId);
  const sourceField = layer.allColumns.find(f => f.columnId === source.id);
  if ((0, _utils.isDraggedField)(source)) {
    var _sourceField$meta;
    const nextLabel = source.humanData.label;
    if (target !== null && target !== void 0 && target.isMetricDimension && (sourceField === null || sourceField === void 0 ? void 0 : (_sourceField$meta = sourceField.meta) === null || _sourceField$meta === void 0 ? void 0 : _sourceField$meta.type) !== 'number') {
      return;
    }
    return {
      dropTypes: [targetColumn ? 'field_replace' : 'field_add'],
      nextLabel
    };
  }
  if ((0, _types.isOperation)(source)) {
    var _sourceField$meta2, _targetField$meta;
    if (source.layerId !== target.layerId) return;
    const nextLabel = source.humanData.label;
    if ((0, _utils.isOperationFromTheSameGroup)(source, target)) {
      if (!targetColumn) {
        return {
          dropTypes: ['duplicate_compatible'],
          nextLabel
        };
      }
      return {
        dropTypes: ['reorder'],
        nextLabel
      };
    }
    const sourceFieldCanMoveToMetricDimension = (0, _utils2.canColumnBeDroppedInMetricDimension)(layer.allColumns, sourceField === null || sourceField === void 0 ? void 0 : (_sourceField$meta2 = sourceField.meta) === null || _sourceField$meta2 === void 0 ? void 0 : _sourceField$meta2.type);
    const targetFieldCanMoveToMetricDimension = (0, _utils2.canColumnBeDroppedInMetricDimension)(layer.allColumns, targetField === null || targetField === void 0 ? void 0 : (_targetField$meta = targetField.meta) === null || _targetField$meta === void 0 ? void 0 : _targetField$meta.type);
    const isMoveable = !(target !== null && target !== void 0 && target.isMetricDimension) || target.isMetricDimension && sourceFieldCanMoveToMetricDimension;
    if (targetColumn) {
      const isSwappable = isMoveable && !(source !== null && source !== void 0 && source.isMetricDimension) || source.isMetricDimension && targetFieldCanMoveToMetricDimension;
      if (isMoveable) {
        if (isSwappable) {
          return {
            dropTypes: ['replace_compatible', 'replace_duplicate_compatible', 'swap_compatible'],
            nextLabel
          };
        }
        return {
          dropTypes: ['replace_compatible', 'replace_duplicate_compatible'],
          nextLabel
        };
      }
    } else {
      if (isMoveable) {
        return {
          dropTypes: ['move_compatible', 'duplicate_compatible'],
          nextLabel
        };
      }
    }
  }
  return;
};
exports.getDropProps = getDropProps;