"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldByNameFactory = getFieldByNameFactory;
var _lodash = require("lodash");
var _document_field = require("./document_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFieldByNameFactory(newFields, addRecordsField = true) {
  const fieldsLookup = (0, _lodash.keyBy)(newFields, 'name');
  if (addRecordsField) {
    fieldsLookup[_document_field.documentField.name] = _document_field.documentField;
  }
  return name => fieldsLookup[name];
}