"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerConfiguration = LayerConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _workspace_panel = require("../../../editor_frame_service/editor_frame/workspace_panel");
var _config_panel = require("../../../editor_frame_service/editor_frame/config_panel/config_panel");
var _service = require("../../../data_views_service/service");
var _state_management = require("../../../state_management");
var _lens_slice = require("../../../state_management/lens_slice");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerConfiguration({
  attributes,
  coreStart,
  startDependencies,
  visualizationMap,
  datasourceMap,
  datasourceId,
  framePublicAPI,
  hasPadding,
  setIsInlineFlyoutVisible,
  getUserMessages
}) {
  var _visualization$active;
  const dispatch = (0, _state_management.useLensDispatch)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    visualization
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const activeVisualization = visualizationMap[(_visualization$active = visualization.activeId) !== null && _visualization$active !== void 0 ? _visualization$active : attributes.visualizationType];
  const indexPatternService = (0, _react.useMemo)(() => (0, _service.createIndexPatternService)({
    dataViews: startDependencies.dataViews,
    uiActions: startDependencies.uiActions,
    core: coreStart,
    updateIndexPatterns: (newIndexPatternsState, options) => {
      dispatch((0, _state_management.updateIndexPatterns)(newIndexPatternsState));
    },
    replaceIndexPattern: (newIndexPattern, oldId, options) => {
      dispatch((0, _lens_slice.replaceIndexpattern)({
        newIndexPattern,
        oldId
      }));
    }
  }), [coreStart, dispatch, startDependencies.dataViews, startDependencies.uiActions]);
  const layerPanelsProps = {
    framePublicAPI,
    datasourceMap,
    visualizationMap,
    core: coreStart,
    dataViews: startDependencies.dataViews,
    uiActions: startDependencies.uiActions,
    hideLayerHeader: datasourceId === 'textBased',
    indexPatternService,
    setIsInlineFlyoutVisible,
    getUserMessages
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: ${hasPadding ? euiTheme.size.s : 0};
      `
  }, /*#__PURE__*/_react.default.createElement(_workspace_panel.VisualizationToolbar, {
    activeVisualization: activeVisualization,
    framePublicAPI: framePublicAPI
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_config_panel.ConfigPanelWrapper, layerPanelsProps));
}