"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsMenu = SettingsMenu;
exports.toggleSettingsMenuOpen = toggleSettingsMenuOpen;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _state_management = require("../state_management");
var _settings_storage = require("../settings_storage");
var _workspace_panel_wrapper = require("../editor_frame_service/editor_frame/workspace_panel/workspace_panel_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const container = document.createElement('div');
let isMenuOpen = false;

// exported for testing purposes only
function SettingsMenu({
  anchorElement,
  isOpen,
  onClose
}) {
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const dispatch = (0, _state_management.useLensDispatch)();
  const toggleAutoApply = (0, _react.useCallback)(() => {
    onClose();
    (0, _settings_storage.writeToStorage)(new _public.Storage(localStorage), _workspace_panel_wrapper.AUTO_APPLY_DISABLED_STORAGE_KEY, String(autoApplyEnabled));
    dispatch(autoApplyEnabled ? (0, _state_management.disableAutoApply)() : (0, _state_management.enableAutoApply)());
  }, [dispatch, autoApplyEnabled, onClose]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    "data-test-subj": "lnsApp__settingsMenu",
    ownFocus: true,
    button: anchorElement,
    closePopover: onClose,
    isOpen: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.settings.title",
    defaultMessage: "Lens settings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.settings.autoApply', {
      defaultMessage: 'Auto-apply visualization changes'
    }),
    checked: autoApplyEnabled,
    onChange: () => toggleAutoApply(),
    "data-test-subj": "lnsToggleAutoApply"
  }));
}
function closeSettingsMenu() {
  _reactDom.default.unmountComponentAtNode(container);
  document.body.removeChild(container);
  isMenuOpen = false;
}

/**
 * Toggles the settings menu
 *
 * Note: the code inside this function is covered only at the functional test level
 */
function toggleSettingsMenuOpen(props) {
  if (isMenuOpen) {
    closeSettingsMenu();
    return;
  }
  isMenuOpen = true;
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: props.lensStore
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
    theme$: props.theme$
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(SettingsMenu, (0, _extends2.default)({}, props, {
    isOpen: isMenuOpen,
    onClose: closeSettingsMenu
  })))));
  _reactDom.default.render(element, container);
}