"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensAppLocatorDefinition = exports.LENS_SHARE_STATE_ACTION = exports.LENS_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LENS_APP_LOCATOR = 'LENS_APP_LOCATOR';
exports.LENS_APP_LOCATOR = LENS_APP_LOCATOR;
const LENS_SHARE_STATE_ACTION = 'LENS_SHARE_STATE_ACTION';

/**
 * Location state of scoped history (history instance of Kibana Platform application service)
 */
exports.LENS_SHARE_STATE_ACTION = LENS_SHARE_STATE_ACTION;
function getStateFromParams(params) {
  if (params.savedObjectId) {
    return {};
  }

  // return no state for malformed state?
  if (!(params.activeDatasourceId && params.datasourceStates && params.visualization && params.references)) {
    return {};
  }
  const outputState = {
    activeDatasourceId: params.activeDatasourceId,
    visualization: params.visualization,
    datasourceStates: Object.fromEntries(Object.entries(params.datasourceStates).map(([id, {
      state
    }]) => [id, state])),
    references: params.references
  };
  if (params.dataViewSpecs) {
    outputState.dataViewSpecs = params.dataViewSpecs;
  }
  return outputState;
}
class LensAppLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", LENS_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        filters,
        query,
        savedObjectId,
        resolvedDateRange,
        searchSessionId
      } = params;
      const appState = getStateFromParams(params);
      const queryState = {};
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      if (query) {
        appState.query = query;
      }
      if (resolvedDateRange) {
        appState.resolvedDateRange = resolvedDateRange;
        queryState.time = {
          from: resolvedDateRange.fromDate,
          to: resolvedDateRange.toDate
        };
      }
      if (filters !== null && filters !== void 0 && filters.length) {
        appState.filters = filters;
        queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !isFilterPinned(f));
      }
      const savedObjectPath = savedObjectId ? `/edit/${encodeURIComponent(savedObjectId)}` : '';
      const basepath = `${window.location.origin}${window.location.pathname}`;
      const url = new URL(basepath);
      url.hash = savedObjectPath;
      url.searchParams.append('_g', _rison.default.encodeUnknown(queryState) || '');
      if (searchSessionId) {
        appState.searchSessionId = searchSessionId;
      }
      return {
        app: 'lens',
        path: url.href.replace(basepath, ''),
        state: {
          type: LENS_SHARE_STATE_ACTION,
          payload: appState
        }
      };
    });
  }
}
exports.LensAppLocatorDefinition = LensAppLocatorDefinition;