"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNumericFieldForDatatable = isNumericFieldForDatatable;
var _transpose_helpers = require("./transpose_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isNumericFieldForDatatable(currentData, accessor) {
  const column = currentData === null || currentData === void 0 ? void 0 : currentData.columns.find(col => col.id === accessor || (0, _transpose_helpers.getOriginalId)(col.id) === accessor);
  return (column === null || column === void 0 ? void 0 : column.meta.type) === 'number';
}