"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensConfigBuilder = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _uuid = require("uuid");
var _charts = require("./charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class LensConfigBuilder {
  constructor(formulaAPI, dataViewsAPI) {
    (0, _defineProperty2.default)(this, "charts", {
      metric: _charts.buildMetric,
      tagcloud: _charts.buildTagCloud,
      treemap: _charts.buildPartitionChart,
      pie: _charts.buildPartitionChart,
      donut: _charts.buildPartitionChart,
      gauge: _charts.buildGauge,
      heatmap: _charts.buildHeatmap,
      mosaic: _charts.buildPartitionChart,
      regionmap: _charts.buildRegionMap,
      xy: _charts.buildXY,
      table: _charts.buildTable
    });
    (0, _defineProperty2.default)(this, "formulaAPI", void 0);
    (0, _defineProperty2.default)(this, "dataViewsAPI", void 0);
    this.formulaAPI = formulaAPI;
    this.dataViewsAPI = dataViewsAPI;
  }
  async build(config, options = {}) {
    const {
      chartType
    } = config;
    const chartConfig = await this.charts[chartType](config, {
      formulaAPI: this.formulaAPI,
      dataViewsAPI: this.dataViewsAPI
    });
    const chartState = {
      ...chartConfig,
      state: {
        ...chartConfig.state,
        filters: options.filters || [],
        query: options.query || {
          language: 'kuery',
          query: ''
        }
      }
    };
    if (options.embeddable) {
      return {
        id: (0, _uuid.v4)(),
        attributes: chartState,
        timeRange: options.timeRange,
        references: chartState.references
      };
    }
    return chartState;
  }
}
exports.LensConfigBuilder = LensConfigBuilder;