"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHistogramColumn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getHistogramColumn = ({
  options
}) => {
  var _options$params;
  const {
    interval = 'auto',
    ...rest
  } = (_options$params = options === null || options === void 0 ? void 0 : options.params) !== null && _options$params !== void 0 ? _options$params : {};
  return {
    dataType: 'date',
    isBucketed: true,
    label: '@timestamp',
    operationType: 'date_histogram',
    scale: 'interval',
    sourceField: '@timestamp',
    ...options,
    params: {
      interval,
      ...rest
    }
  };
};
exports.getHistogramColumn = getHistogramColumn;