"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRegionMap = buildRegionMap;
var _types = require("../types");
var _utils = require("../utils");
var _columns = require("../columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACCESSOR = 'metric_formula_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    valueAccessor: ACCESSOR,
    ...(layer.breakdown ? {
      regionAccessor: getAccessorName('breakdown')
    } : {})
  };
}
function buildFormulaLayer(layer, i, dataView, formulaAPI) {
  const layers = {
    [_types.DEFAULT_LAYER_ID]: {
      ...(0, _columns.getFormulaColumn)(ACCESSOR, {
        value: layer.value
      }, dataView, formulaAPI)
    }
  };
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  if (layer.breakdown) {
    const columnName = getAccessorName('breakdown');
    const breakdownColumn = (0, _columns.getBreakdownColumn)({
      options: layer.breakdown,
      dataView
    });
    (0, _utils.addLayerColumn)(defaultLayer, columnName, breakdownColumn, true);
  } else {
    throw new Error('breakdown must be defined for regionmap!');
  }
  return defaultLayer;
}
function getValueColumns(layer) {
  if (typeof layer.breakdown !== 'string') {
    throw new Error('breakdown must be a field name when not using index source');
  }
  return [(0, _columns.getValueColumn)(ACCESSOR, layer.value), (0, _columns.getValueColumn)(getAccessorName('breakdown'), layer.breakdown)];
}
async function buildRegionMap(config, {
  dataViewsAPI,
  formulaAPI
}) {
  const dataviews = {};
  const _buildFormulaLayer = (cfg, i, dataView) => buildFormulaLayer(cfg, i, dataView, formulaAPI);
  const datasourceStates = await (0, _utils.buildDatasourceStates)(config, dataviews, _buildFormulaLayer, getValueColumns, dataViewsAPI);
  return {
    title: config.title,
    visualizationType: 'lnsChoropleth',
    references: (0, _utils.buildReferences)(dataviews),
    state: {
      datasourceStates,
      internalReferences: [],
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: buildVisualizationState(config),
      // Getting the spec from a data view is a heavy operation, that's why the result is cached.
      adHocDataViews: (0, _utils.getAdhocDataviews)(dataviews)
    }
  };
}