"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XYReferenceLinesLayer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../../utils");
var _static = require("./columns/static");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class XYReferenceLinesLayer {
  constructor(layerConfig) {
    var _layerConfig$layerTyp;
    (0, _defineProperty2.default)(this, "column", void 0);
    (0, _defineProperty2.default)(this, "layerConfig", void 0);
    this.column = layerConfig.data.map(p => new _static.StaticColumn(p));
    this.layerConfig = {
      ...layerConfig,
      layerType: (_layerConfig$layerTyp = layerConfig.layerType) !== null && _layerConfig$layerTyp !== void 0 ? _layerConfig$layerTyp : 'referenceLine'
    };
  }
  getName() {
    return this.column[0].getValueConfig().label;
  }
  getLayer(layerId, accessorId) {
    const baseLayer = {
      columnOrder: [],
      columns: {}
    };
    return {
      [`${layerId}_reference`]: this.column.reduce((acc, curr, index) => {
        return {
          ...acc,
          ...curr.getData(`${accessorId}_${index}_reference_column`, acc)
        };
      }, baseLayer)
    };
  }
  getReference(layerId, chartDataView) {
    var _this$layerConfig$dat;
    return (0, _utils.getDefaultReferences)((_this$layerConfig$dat = this.layerConfig.dataView) !== null && _this$layerConfig$dat !== void 0 ? _this$layerConfig$dat : chartDataView, `${layerId}_reference`);
  }
  getLayerConfig(layerId, accessorId) {
    return {
      layerId: `${layerId}_reference`,
      layerType: 'referenceLine',
      accessors: this.column.map((_, index) => `${accessorId}_${index}_reference_column`),
      yConfig: this.column.map((layer, index) => ({
        color: layer.getValueConfig().color,
        forAccessor: `${accessorId}_${index}_reference_column`,
        axisMode: 'left',
        fill: layer.getValueConfig().fill
      }))
    };
  }
  getDataView() {
    return this.layerConfig.dataView;
  }
}
exports.XYReferenceLinesLayer = XYReferenceLinesLayer;