"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormulaColumn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class FormulaColumn {
  constructor(valueConfig) {
    this.valueConfig = valueConfig;
  }
  getValueConfig() {
    return this.valueConfig;
  }
  getData(id, baseLayer, dataView, formulaAPI) {
    const {
      value,
      ...rest
    } = this.getValueConfig();
    const formulaLayer = formulaAPI.insertOrReplaceFormulaColumn(id, {
      formula: value,
      ...rest
    }, baseLayer, dataView);
    if (!formulaLayer) {
      throw new Error('Error generating the data layer for the chart');
    }
    return formulaLayer;
  }
}
exports.FormulaColumn = FormulaColumn;