"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopValuesColumn = exports.getHistogramColumn = exports.getDefaultReferences = exports.getAdhocDataView = exports.DEFAULT_LAYER_ID = exports.DEFAULT_AD_HOC_DATA_VIEW_ID = void 0;
exports.nonNullable = nonNullable;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_LAYER_ID = 'layer';
exports.DEFAULT_LAYER_ID = DEFAULT_LAYER_ID;
const DEFAULT_AD_HOC_DATA_VIEW_ID = 'infra_lens_ad_hoc_default';
exports.DEFAULT_AD_HOC_DATA_VIEW_ID = DEFAULT_AD_HOC_DATA_VIEW_ID;
const DEFAULT_BREAKDOWN_SIZE = 10;
function nonNullable(v) {
  return v != null;
}
const getHistogramColumn = ({
  columnName,
  options
}) => {
  var _options$params, _options$sourceField;
  const {
    interval = 'auto',
    ...rest
  } = (_options$params = options === null || options === void 0 ? void 0 : options.params) !== null && _options$params !== void 0 ? _options$params : {};
  return {
    [columnName]: {
      dataType: 'date',
      isBucketed: true,
      label: '@timestamp',
      operationType: 'date_histogram',
      scale: 'interval',
      sourceField: (_options$sourceField = options === null || options === void 0 ? void 0 : options.sourceField) !== null && _options$sourceField !== void 0 ? _options$sourceField : '@timestamp',
      params: {
        interval,
        ...rest
      }
    }
  };
};
exports.getHistogramColumn = getHistogramColumn;
const getTopValuesColumn = ({
  columnName,
  field,
  options
}) => {
  const {
    size = DEFAULT_BREAKDOWN_SIZE,
    ...params
  } = options !== null && options !== void 0 ? options : {};
  return {
    [columnName]: {
      label: `Top ${size} values of ${field}`,
      dataType: 'string',
      operationType: 'terms',
      scale: 'ordinal',
      sourceField: field,
      isBucketed: true,
      params: {
        size,
        orderBy: {
          type: 'alphabetical',
          fallback: false
        },
        orderDirection: 'asc',
        otherBucket: false,
        missingBucket: false,
        parentFormat: {
          id: 'terms'
        },
        include: [],
        exclude: [],
        includeIsRegex: false,
        excludeIsRegex: false,
        ...params
      }
    }
  };
};
exports.getTopValuesColumn = getTopValuesColumn;
const getDefaultReferences = (dataView, dataLayerId) => {
  var _dataView$id;
  return [{
    type: 'index-pattern',
    id: (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : DEFAULT_AD_HOC_DATA_VIEW_ID,
    name: `indexpattern-datasource-layer-${dataLayerId}`
  }];
};
exports.getDefaultReferences = getDefaultReferences;
const getAdhocDataView = dataViewSpec => {
  var _dataViewSpec$id;
  return {
    [(_dataViewSpec$id = dataViewSpec.id) !== null && _dataViewSpec$id !== void 0 ? _dataViewSpec$id : DEFAULT_AD_HOC_DATA_VIEW_ID]: {
      ...dataViewSpec
    }
  };
};
exports.getAdhocDataView = getAdhocDataView;