"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addTreeNavSelectionToFilterQuery = exports.KUBERNETES_COLLECTION_ICONS_PROPS = exports.KUBERNETES_COLLECTION_FIELDS = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KUBERNETES_COLLECTION_FIELDS = {
  clusterId: _constants.ORCHESTRATOR_CLUSTER_ID,
  clusterName: _constants.ORCHESTRATOR_CLUSTER_NAME,
  namespace: _constants.ORCHESTRATOR_NAMESPACE,
  node: _constants.CLOUD_INSTANCE_NAME,
  pod: _constants.ORCHESTRATOR_RESOURCE_ID,
  containerImage: _constants.CONTAINER_IMAGE_NAME
};
exports.KUBERNETES_COLLECTION_FIELDS = KUBERNETES_COLLECTION_FIELDS;
const KUBERNETES_COLLECTION_ICONS_PROPS = {
  clusterId: {
    type: 'cluster',
    euiVarColor: 'euiColorVis0'
  },
  clusterName: {
    type: 'cluster',
    euiVarColor: 'euiColorVis0'
  },
  namespace: {
    type: 'namespace',
    euiVarColor: 'euiColorVis1'
  },
  node: {
    type: 'kubernetesNode',
    euiVarColor: 'euiColorVis3'
  },
  pod: {
    type: 'kubernetesPod',
    euiVarColor: 'euiColorVis9'
  },
  containerImage: {
    type: 'container',
    euiVarColor: 'euiColorVis8'
  }
};
exports.KUBERNETES_COLLECTION_ICONS_PROPS = KUBERNETES_COLLECTION_ICONS_PROPS;
const addTreeNavSelectionToFilterQuery = (filterQuery, treeNavSelection) => {
  let validFilterQuery = _constants.DEFAULT_FILTER_QUERY;
  try {
    var _parsedFilterQuery$bo;
    const parsedFilterQuery = JSON.parse(filterQuery || '{}');
    if (!(parsedFilterQuery !== null && parsedFilterQuery !== void 0 && (_parsedFilterQuery$bo = parsedFilterQuery.bool) !== null && _parsedFilterQuery$bo !== void 0 && _parsedFilterQuery$bo.filter && Array.isArray(parsedFilterQuery.bool.filter))) {
      throw new Error('Invalid filter query');
    }
    parsedFilterQuery.bool.filter.push(...Object.entries(treeNavSelection).filter(([key]) => key !== 'clusterName').map(obj => {
      const [key, value] = obj;
      return {
        bool: {
          should: [{
            match: {
              [KUBERNETES_COLLECTION_FIELDS[key]]: value
            }
          }]
        }
      };
    }));
    validFilterQuery = JSON.stringify(parsedFilterQuery);
  } catch {
    // no-op since validFilterQuery is initialized to be DEFAULT_FILTER_QUERY
  }
  return validFilterQuery;
};
exports.addTreeNavSelectionToFilterQuery = addTreeNavSelectionToFilterQuery;