"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaOverviewApp = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _overview = require("./overview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KibanaOverviewApp = ({
  basename,
  newsfeed$,
  features$,
  solutions
}) => {
  const features = (0, _useObservable.default)(features$, []);
  const [newsFetchResult, setNewsFetchResult] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (newsfeed$) {
      const subscription = newsfeed$.subscribe(res => {
        setNewsFetchResult(res);
      });
      return () => subscription.unsubscribe();
    }
  }, [newsfeed$]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.HashRouter, {
    basename: basename
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_overview.Overview, {
    newsFetchResult,
    solutions,
    features
  })))));
};
exports.KibanaOverviewApp = KibanaOverviewApp;