"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputControlVisPlugin = void 0;
var _input_control_fn = require("./input_control_fn");
var _input_control_vis_renderer = require("./input_control_vis_renderer");
var _input_control_vis_type = require("./input_control_vis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

/** @internal */
class InputControlVisPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    visualizations,
    unifiedSearch,
    data
  }) {
    const visualizationDependencies = {
      core,
      unifiedSearch,
      getSettings: async () => {
        const {
          timeout,
          terminateAfter
        } = unifiedSearch.autocomplete.getAutocompleteSettings();
        return {
          autocompleteTimeout: timeout,
          autocompleteTerminateAfter: terminateAfter
        };
      },
      data
    };
    expressions.registerFunction(_input_control_fn.createInputControlVisFn);
    expressions.registerRenderer((0, _input_control_vis_renderer.getInputControlVisRenderer)(visualizationDependencies));
    const {
      readOnly
    } = this.initializerContext.config.get();
    visualizations.createBaseVisualization((0, _input_control_vis_type.createInputControlVisTypeDefinition)(visualizationDependencies, Boolean(readOnly)));
  }
  start(core, deps) {
    // nothing to do here
  }
}
exports.InputControlVisPlugin = InputControlVisPlugin;