"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getListPath = exports.getEditPath = exports.getCreatePath = exports.getCreateFromCsvPath = exports.getClonePath = exports.ROUTES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_PATH = '/';
const EDIT_PATH = 'edit';
const CREATE_PATH = 'create';
const CREATE_FROM_CSV_PATH = 'csv_create';
const _getEditPath = (name, encode = true) => {
  return `${BASE_PATH}${EDIT_PATH}/${encode ? encodeURIComponent(name) : name}`;
};
const _getCreatePath = () => {
  return `${BASE_PATH}${CREATE_PATH}`;
};
const _getClonePath = (name, encode = true) => {
  return `${BASE_PATH}${CREATE_PATH}/${encode ? encodeURIComponent(name) : name}`;
};
const _getListPath = name => {
  return `${BASE_PATH}${name ? `?pipeline=${encodeURIComponent(name)}` : ''}`;
};
const _getCreateFromCsvPath = () => {
  return `${BASE_PATH}${CREATE_FROM_CSV_PATH}`;
};
const ROUTES = {
  list: _getListPath(),
  edit: _getEditPath(':name', false),
  create: _getCreatePath(),
  clone: _getClonePath(':sourceName', false),
  createFromCsv: _getCreateFromCsvPath()
};
exports.ROUTES = ROUTES;
const getListPath = ({
  inspectedPipelineName
} = {}) => _getListPath(inspectedPipelineName);
exports.getListPath = getListPath;
const getEditPath = ({
  pipelineName
}) => _getEditPath(pipelineName, true);
exports.getEditPath = getEditPath;
const getCreatePath = () => _getCreatePath();
exports.getCreatePath = getCreatePath;
const getClonePath = ({
  clonedPipelineName
}) => _getClonePath(clonedPipelineName, true);
exports.getClonePath = getClonePath;
const getCreateFromCsvPath = () => _getCreateFromCsvPath();
exports.getCreateFromCsvPath = getCreateFromCsvPath;