"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineTable = ({
  pipelines,
  onReloadClick,
  onEditPipelineClick,
  onClonePipelineClick,
  onDeletePipelineClick
}) => {
  const {
    history
  } = (0, _shared_imports.useKibana)().services;
  const [selection, setSelection] = (0, _react.useState)([]);
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const createMenuItems = [
  /**
   * Create pipeline
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineButtonLabel', {
      defaultMessage: 'New pipeline'
    }),
    ...(0, _public.reactRouterNavigate)(history, '/create'),
    'data-test-subj': `createNewPipeline`
  },
  /**
   * Create pipeline from CSV
   */
  {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineFromCsvButtonLabel', {
      defaultMessage: 'New pipeline from CSV'
    }),
    ...(0, _public.reactRouterNavigate)(history, '/csv_create'),
    'data-test-subj': `createPipelineFromCsv`
  }];
  const tableProps = {
    itemId: 'name',
    isSelectable: true,
    'data-test-subj': 'pipelinesTable',
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    },
    selection: {
      onSelectionChange: setSelection
    },
    rowProps: () => ({
      'data-test-subj': 'pipelineTableRow'
    }),
    cellProps: (pipeline, column) => {
      const {
        field
      } = column;
      return {
        'data-test-subj': `pipelineTableRow-${field}`
      };
    },
    search: {
      toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "deletePipelinesButton",
        onClick: () => onDeletePipelineClick(selection.map(pipeline => pipeline.name)),
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.table.deletePipelinesButtonLabel",
        defaultMessage: "Delete {count, plural, one {pipeline} other {pipelines} }",
        values: {
          count: selection.length
        }
      })) : undefined,
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "reloadButton",
        iconType: "refresh",
        color: "success",
        "data-test-subj": "reloadButton",
        onClick: onReloadClick
      }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.reloadButtonLabel', {
        defaultMessage: 'Reload'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        isOpen: showPopover,
        closePopover: () => setShowPopover(false),
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          fill: true,
          iconSide: "right",
          iconType: "arrowDown",
          "data-test-subj": "createPipelineDropdown",
          key: "createPipelineDropdown",
          onClick: () => setShowPopover(previousBool => !previousBool)
        }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.createPipelineDropdownLabel', {
          defaultMessage: 'Create pipeline'
        })),
        panelPaddingSize: "none",
        repositionOnScroll: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
        initialPanelId: 0,
        "data-test-subj": "autoFollowPatternActionContextMenu",
        panels: [{
          id: 0,
          items: createMenuItems
        }]
      }))],
      box: {
        incremental: true
      },
      filters: [{
        type: 'is',
        field: 'isManaged',
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.isManagedFilterLabel', {
          defaultMessage: 'Managed'
        })
      }]
    },
    pagination: {
      initialPageSize: 10,
      pageSizeOptions: [10, 20, 50]
    },
    columns: [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      render: (name, pipeline) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "pipelineDetailsLink"
      }, (0, _public.reactRouterNavigate)(history, {
        pathname: '/',
        search: `pipeline=${encodeURIComponent(name)}`
      })), name, pipeline.isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "isManagedBadge"
      }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.managedBadgeLabel', {
        defaultMessage: 'Managed'
      }))))
    }, {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.table.actionColumnTitle",
        defaultMessage: "Actions"
      }),
      actions: [{
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.editActionLabel', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.editActionDescription', {
          defaultMessage: 'Edit this pipeline'
        }),
        type: 'icon',
        icon: 'pencil',
        onClick: ({
          name
        }) => onEditPipelineClick(name)
      }, {
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.cloneActionLabel', {
          defaultMessage: 'Clone'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.cloneActionDescription', {
          defaultMessage: 'Clone this pipeline'
        }),
        type: 'icon',
        icon: 'copy',
        onClick: ({
          name
        }) => onClonePipelineClick(name)
      }, {
        isPrimary: true,
        name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deleteActionLabel', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.ingestPipelines.list.table.deleteActionDescription', {
          defaultMessage: 'Delete this pipeline'
        }),
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        onClick: ({
          name
        }) => onDeletePipelineClick([name])
      }]
    }],
    items: pipelines !== null && pipelines !== void 0 ? pipelines : []
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, tableProps);
};
exports.PipelineTable = PipelineTable;