"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _navigation = require("../../services/navigation");
var _components = require("../../components");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagedPipelineCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "danger",
  iconType: "warning",
  "data-test-subj": "managedPipelineCallout",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.edit.managedCalloutTitle",
    defaultMessage: "Editing a managed pipeline can break Kibana."
  })
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ingestPipelines.edit.managedCalloutDescription",
  defaultMessage: "Managed pipelines are critical for internal operations."
}));
const PipelinesEdit = ({
  match: {
    params: {
      name
    }
  },
  history
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const redirectToPathOrRedirectPath = (0, _hooks.useRedirectToPathOrRedirectPath)(history);
  const decodedPipelineName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    error,
    data: pipeline,
    isLoading,
    resendRequest
  } = services.api.useLoadPipeline(decodedPipelineName);
  const onSave = async updatedPipeline => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error: savePipelineError
    } = await services.api.updatePipeline(updatedPipeline);
    setIsSaving(false);
    if (savePipelineError) {
      setSaveError(savePipelineError);
      return;
    }
    redirectToPathOrRedirectPath((0, _navigation.getListPath)({
      inspectedPipelineName: updatedPipeline.name
    }));
  };
  const onCancel = () => {
    redirectToPathOrRedirectPath((0, _navigation.getListPath)());
  };
  (0, _react.useEffect)(() => {
    services.breadcrumbs.setBreadcrumbs('edit');
  }, [services.breadcrumbs]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.edit.loadingPipelinesDescription",
      defaultMessage: "Loading pipeline\u2026"
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.edit.fetchPipelineError",
        defaultMessage: "Unable to load '{name}'",
        values: {
          name: decodedPipelineName
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, error.message),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.edit.fetchPipelineReloadButton",
        defaultMessage: "Try again"
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.edit.pageTitle",
      defaultMessage: "Edit pipeline '{name}'",
      values: {
        name: decodedPipelineName
      }
    })),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: services.documentation.getCreatePipelineUrl(),
      target: "_blank",
      iconType: "help",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.edit.docsButtonLabel",
      defaultMessage: "Edit pipeline docs"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), (pipeline === null || pipeline === void 0 ? void 0 : pipeline.isManaged) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ManagedPipelineCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_components.PipelineForm, {
    onSave: onSave,
    onCancel: onCancel,
    isSaving: isSaving,
    saveError: saveError,
    defaultValue: pipeline,
    isEditing: true
  }));
};
exports.PipelinesEdit = PipelinesEdit;