"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nTexts = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  title: _i18n.i18n.translate('xpack.ingestPipelines.form.savePipelineError', {
    defaultMessage: 'Unable to create pipeline'
  }),
  errors: {
    processor: processorType => _i18n.i18n.translate('xpack.ingestPipelines.form.savePipelineError.processorLabel', {
      defaultMessage: '{type} processor',
      values: {
        type: processorType
      }
    }),
    showErrors: hiddenErrorsCount => _i18n.i18n.translate('xpack.ingestPipelines.form.savePipelineError.showAllButton', {
      defaultMessage: 'Show {hiddenErrorsCount, plural, one {# more error} other {# more errors}}',
      values: {
        hiddenErrorsCount
      }
    }),
    hideErrors: hiddenErrorsCount => _i18n.i18n.translate('xpack.ingestPipelines.form.savePip10mbelineError.showFewerButton', {
      defaultMessage: 'Hide {hiddenErrorsCount, plural, one {# error} other {# errors}}',
      values: {
        hiddenErrorsCount
      }
    }),
    unknownError: _i18n.i18n.translate('xpack.ingestPipelines.form.unknownError', {
      defaultMessage: 'An unknown error occurred.'
    })
  }
};
exports.i18nTexts = i18nTexts;