"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDocumentsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../../shared_imports");
var _use_is_mounted = require("../../../../../use_is_mounted");
var _add_document_form = require("../add_document_form");
require("./add_docs_accordion.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  addDocumentsButton: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocumentsAccordion.addDocumentsButtonLabel', {
    defaultMessage: 'Add a test document from an index'
  }),
  addDocumentsDescription: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocumentsAccordion.contentDescriptionText', {
    defaultMessage: `Provide the document's index and document ID.`
  })
};
const AddDocumentsAccordion = ({
  onAddDocuments
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const isMounted = (0, _use_is_mounted.useIsMounted)();
  const [discoverLink, setDiscoverLink] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const getDiscoverUrl = async () => {
      var _services$share;
      const locator = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators.get('DISCOVER_APP_LOCATOR');
      if (!locator) {
        setDiscoverLink(undefined);
        return;
      }
      const discoverUrl = await locator.getUrl({
        indexPatternId: undefined
      });
      if (!isMounted.current) return;
      setDiscoverLink(discoverUrl);
    };
    getDiscoverUrl();
  }, [isMounted, services.share]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "addDocumentsAccordion",
    buttonContent: i18nTexts.addDocumentsButton,
    paddingSize: "s",
    "data-test-subj": "addDocumentsAccordion"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "addDocumentsAccordion"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.addDocumentsDescription, discoverLink && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.pipelineEditor.addDocumentsAccordion.discoverLinkDescriptionText",
    defaultMessage: "To explore your existing data, use {discoverLink}.",
    values: {
      discoverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: discoverLink,
        target: "_blank",
        external: true
      }, "Discover")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_add_document_form.AddDocumentForm, {
    onAddDocuments: onAddDocuments
  })));
};
exports.AddDocumentsAccordion = AddDocumentsAccordion;