"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsConfig = exports.FieldNameField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  field: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.fieldFieldLabel', {
      defaultMessage: 'Field'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.fieldRequiredError', {
        defaultMessage: 'A field value is required.'
      }))
    }]
  }
};
exports.fieldsConfig = fieldsConfig;
const FieldNameField = ({
  helpText,
  additionalValidations
}) => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  config: {
    ...fieldsConfig.field,
    helpText,
    validations: fieldsConfig.field.validations.concat(additionalValidations !== null && additionalValidations !== void 0 ? additionalValidations : [])
  },
  component: _shared_imports.Field,
  path: "fields.field",
  "data-test-subj": "fieldNameField"
});
exports.FieldNameField = FieldNameField;