"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inventoryViewSavedObjectRT = exports.inventoryViewSavedObjectAttributesRT = exports.inventorySavedObjectViewOptionsRT = exports.inventorySavedObjectSortOptionRT = exports.inventorySavedObjectOptionsStateRT = exports.inventorySavedObjectFiltersStateRT = exports.inventorySavedObjectColorPaletteRT = exports.inventorySabedObjectMapBoundsRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventorySavedObjectColorPaletteRT = rt.keyof({
  status: null,
  temperature: null,
  cool: null,
  warm: null,
  positive: null,
  negative: null
});
exports.inventorySavedObjectColorPaletteRT = inventorySavedObjectColorPaletteRT;
const inventorySavedObjectLegendOptionsRT = rt.type({
  palette: inventorySavedObjectColorPaletteRT,
  steps: (0, _ioTsUtils.inRangeRt)(2, 18),
  reverseColors: rt.boolean
});
const inventorySavedObjectSortOptionRT = rt.type({
  by: rt.keyof({
    name: null,
    value: null
  }),
  direction: rt.keyof({
    asc: null,
    desc: null
  })
});
exports.inventorySavedObjectSortOptionRT = inventorySavedObjectSortOptionRT;
const inventorySavedObjectViewOptionsRT = rt.keyof({
  table: null,
  map: null
});
exports.inventorySavedObjectViewOptionsRT = inventorySavedObjectViewOptionsRT;
const inventorySabedObjectMapBoundsRT = rt.type({
  min: (0, _ioTsUtils.inRangeRt)(0, 1),
  max: (0, _ioTsUtils.inRangeRt)(0, 1)
});
exports.inventorySabedObjectMapBoundsRT = inventorySabedObjectMapBoundsRT;
const inventorySavedObjectFiltersStateRT = rt.type({
  kind: rt.literal('kuery'),
  expression: rt.string
});
exports.inventorySavedObjectFiltersStateRT = inventorySavedObjectFiltersStateRT;
const inventorySavedObjectOptionsStateRT = rt.intersection([rt.type({
  accountId: rt.string,
  autoBounds: rt.boolean,
  boundsOverride: inventorySabedObjectMapBoundsRT,
  customMetrics: rt.UnknownArray,
  customOptions: rt.array(rt.type({
    text: rt.string,
    field: rt.string
  })),
  groupBy: rt.UnknownArray,
  metric: rt.UnknownRecord,
  nodeType: _common.ItemTypeRT,
  region: rt.string,
  sort: inventorySavedObjectSortOptionRT,
  view: inventorySavedObjectViewOptionsRT
}), rt.partial({
  legend: inventorySavedObjectLegendOptionsRT,
  source: rt.string,
  timelineOpen: rt.boolean
})]);
exports.inventorySavedObjectOptionsStateRT = inventorySavedObjectOptionsStateRT;
const inventoryViewSavedObjectAttributesRT = rt.intersection([inventorySavedObjectOptionsStateRT, rt.type({
  name: _ioTsUtils.nonEmptyStringRt,
  autoReload: rt.boolean,
  filterQuery: inventorySavedObjectFiltersStateRT
}), rt.partial({
  time: rt.number,
  isDefault: rt.boolean,
  isStatic: rt.boolean
})]);
exports.inventoryViewSavedObjectAttributesRT = inventoryViewSavedObjectAttributesRT;
const inventoryViewSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: inventoryViewSavedObjectAttributesRT
}), rt.partial({
  version: rt.string,
  updated_at: _ioTsUtils.isoToEpochRt
})]);
exports.inventoryViewSavedObjectRT = inventoryViewSavedObjectRT;