"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchProfilingFlamegraph = fetchProfilingFlamegraph;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchProfilingFlamegraph({
  hostname,
  from,
  to
}, profilingDataAccess, coreRequestContext) {
  return await profilingDataAccess.services.fetchFlamechartData({
    core: coreRequestContext,
    esClient: coreRequestContext.elasticsearch.client.asCurrentUser,
    rangeFromMs: from,
    rangeToMs: to,
    kuery: `${_constants.HOST_FIELD} : "${hostname}"`
  });
}