"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withReduxDevTools = void 0;
var _dev_mode = require("./dev_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const withReduxDevTools = (stateContainer, config) => {
  if ((0, _dev_mode.isDevMode)() && (0, _dev_mode.hasReduxDevtools)()) {
    const devToolsExtension = (0, _dev_mode.getReduxDevtools)();
    const devToolsInstance = devToolsExtension.connect({
      ...config,
      serialize: {
        ...(typeof (config === null || config === void 0 ? void 0 : config.serialize) === 'object' ? config.serialize : {}),
        replacer: (_key, value) => replaceReactSyntheticEvent(value)
      },
      features: {
        lock: false,
        persist: false,
        import: false,
        jump: false,
        skip: false,
        reorder: false,
        dispatch: false,
        ...(config === null || config === void 0 ? void 0 : config.features)
      }
    });
    devToolsInstance.init(stateContainer.getState());
    stateContainer.addMiddleware(({
      getState
    }) => next => action => {
      devToolsInstance.send(action, getState());
      return next(action);
    });
  }
  return stateContainer;
};
exports.withReduxDevTools = withReduxDevTools;
const isReactSyntheticEvent = value => typeof value === 'object' && value != null && value.nativeEvent instanceof Event;
const replaceReactSyntheticEvent = value => isReactSyntheticEvent(value) ? '[ReactSyntheticEvent]' : value;