"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceConfigurationSettings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _source_loading_page = require("../../../components/source_loading_page");
var _metrics_source = require("../../../containers/metrics_source");
var _infra_ml_capabilities = require("../../../containers/ml/infra_ml_capabilities");
var _indices_configuration_panel = require("./indices_configuration_panel");
var _ml_configuration_panel = require("./ml_configuration_panel");
var _name_configuration_panel = require("./name_configuration_panel");
var _source_configuration_form_state = require("./source_configuration_form_state");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _translations = require("../../../translations");
var _page_template = require("../page_template");
var _features_configuration_panel = require("./features_configuration_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceConfigurationSettings = ({
  shouldAllowEdit
}) => {
  var _source$status;
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.settingsTitle
  }]);
  const {
    createSourceConfiguration,
    source,
    sourceExists,
    isLoading,
    isUninitialized,
    updateSourceConfiguration
  } = (0, _metrics_source.useSourceContext)();
  const {
    indicesConfigurationProps,
    errors,
    resetForm,
    isFormDirty,
    isFormValid,
    formState,
    formStateChanges
  } = (0, _source_configuration_form_state.useSourceConfigurationFormState)(source && source.configuration);
  const infraUiSettings = (0, _public.useEditableSettings)('infra_metrics', [_common.enableInfrastructureHostsView, _common.enableInfrastructureProfilingIntegration]);
  const resetAllUnsavedChanges = (0, _react.useCallback)(() => {
    resetForm();
    infraUiSettings.cleanUnsavedChanges();
  }, [infraUiSettings, resetForm]);
  const persistUpdates = (0, _react.useCallback)(async () => {
    await Promise.all([sourceExists ? updateSourceConfiguration(formStateChanges) : createSourceConfiguration(formState), infraUiSettings.saveAll()]);
    resetForm();
  }, [sourceExists, resetForm, updateSourceConfiguration, formStateChanges, infraUiSettings, createSourceConfiguration, formState]);
  const hasUnsavedChanges = isFormDirty || Object.keys(infraUiSettings.unsavedChanges).length > 0;
  const isWriteable = shouldAllowEdit && (!Boolean(source) || (source === null || source === void 0 ? void 0 : source.origin) !== 'internal');
  const {
    metricIndicesExist,
    remoteClustersExist
  } = (_source$status = source === null || source === void 0 ? void 0 : source.status) !== null && _source$status !== void 0 ? _source$status : {};
  const {
    hasInfraMLCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  if ((isLoading || isUninitialized) && !source) {
    return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
    pageHeader: {
      pageTitle: _translations.settingsTitle
    },
    "data-test-subj": "sourceConfigurationContent",
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public.Prompt, {
    prompt: isFormDirty ? _i18n.i18n.translate('xpack.infra.sourceConfiguration.unsavedFormPrompt', {
      defaultMessage: 'Are you sure you want to leave? Changes will be lost'
    }) : undefined
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_name_configuration_panel.NameConfigurationPanel, {
    isLoading: isLoading,
    nameFieldProps: indicesConfigurationProps.name,
    readOnly: !isWriteable
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_indices_configuration_panel.IndicesConfigurationPanel, {
    isLoading: isLoading,
    metricAliasFieldProps: indicesConfigurationProps.metricAlias,
    readOnly: !isWriteable,
    metricIndicesExist: metricIndicesExist,
    remoteClustersExist: remoteClustersExist
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), hasInfraMLCapabilities && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_ml_configuration_panel.MLConfigurationPanel, {
    isLoading: isLoading,
    readOnly: !isWriteable,
    anomalyThresholdFieldProps: indicesConfigurationProps.anomalyThreshold
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_features_configuration_panel.FeaturesConfigurationPanel, (0, _extends2.default)({
    readOnly: !isWriteable
  }, infraUiSettings))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("ul", null, errors.map((error, errorIndex) => /*#__PURE__*/_react.default.createElement("li", {
    key: errorIndex
  }, error)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading || infraUiSettings.isSaving ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraSourceConfigurationSettingsLoadingButton",
    color: "primary",
    isLoading: true,
    fill: true
  }, _i18n.i18n.translate('xpack.infra.sourceConfiguration.loadingButtonLabel', {
    defaultMessage: 'Loading'
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "discardSettingsButton",
    color: "danger",
    iconType: "cross",
    isDisabled: !hasUnsavedChanges,
    onClick: resetAllUnsavedChanges
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.discardSettingsButtonLabel",
    defaultMessage: "Discard"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "applySettingsButton",
    color: "primary",
    isDisabled: !hasUnsavedChanges || !isFormValid,
    fill: true,
    onClick: persistUpdates
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.applySettingsButtonLabel",
    defaultMessage: "Apply"
  }))))))));
};
exports.SourceConfigurationSettings = SourceConfigurationSettings;