"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTimeControls = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_kibana_ui_setting = require("../../../../utils/use_kibana_ui_setting");
var _map_timepicker_quickranges_to_datepicker_ranges = require("../../../../utils/map_timepicker_quickranges_to_datepicker_ranges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsTimeControls = props => {
  const [timepickerQuickRanges] = (0, _use_kibana_ui_setting.useKibanaUiSetting)(_public.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const {
    onChangeTimeRange,
    onRefresh,
    currentTimeRange,
    isLiveStreaming,
    refreshInterval,
    setAutoReload,
    setRefreshInterval
  } = props;
  const commonlyUsedRanges = (0, _map_timepicker_quickranges_to_datepicker_ranges.mapKibanaQuickRangesToDatePickerRanges)(timepickerQuickRanges);
  const handleTimeChange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    onChangeTimeRange({
      from: start,
      to: end,
      interval: '>=1m'
    });
  }, [onChangeTimeRange]);
  const handleRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval: _refreshInterval
  }) => {
    if (isPaused) {
      setAutoReload(false);
    } else {
      setRefreshInterval(_refreshInterval);
      setAutoReload(true);
    }
  }, [setAutoReload, setRefreshInterval]);
  return /*#__PURE__*/_react.default.createElement(MetricsTimeControlsContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: currentTimeRange.from.toString(),
    end: currentTimeRange.to.toString(),
    isPaused: !isLiveStreaming,
    refreshInterval: refreshInterval ? refreshInterval : 0,
    onTimeChange: handleTimeChange,
    onRefreshChange: handleRefreshChange,
    onRefresh: onRefresh,
    commonlyUsedRanges: commonlyUsedRanges
  }));
};
exports.MetricsTimeControls = MetricsTimeControls;
const MetricsTimeControlsContainer = _common.euiStyled.div`
  max-width: 750px;
`;