"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layout = void 0;
var _react = _interopRequireDefault(require("react"));
var _aws_ec2_layout = require("./layouts/aws_ec2_layout");
var _aws_rds_layout = require("./layouts/aws_rds_layout");
var _aws_s3_layout = require("./layouts/aws_s3_layout");
var _aws_sqs_layout = require("./layouts/aws_sqs_layout");
var _container_layout = require("./layouts/container_layout");
var _pod_layout = require("./layouts/pod_layout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Layout = ({
  inventoryItemType,
  ...layoutProps
}) => {
  switch (inventoryItemType) {
    case 'awsEC2':
      return /*#__PURE__*/_react.default.createElement(_aws_ec2_layout.AwsEC2Layout, layoutProps);
    case 'awsRDS':
      return /*#__PURE__*/_react.default.createElement(_aws_rds_layout.AwsRDSLayout, layoutProps);
    case 'awsS3':
      return /*#__PURE__*/_react.default.createElement(_aws_s3_layout.AwsS3Layout, layoutProps);
    case 'awsSQS':
      return /*#__PURE__*/_react.default.createElement(_aws_sqs_layout.AwsSQSLayout, layoutProps);
    case 'container':
      return /*#__PURE__*/_react.default.createElement(_container_layout.ContainerLayout, layoutProps);
    case 'pod':
      return /*#__PURE__*/_react.default.createElement(_pod_layout.PodLayout, layoutProps);
    default:
      throw new Error(`${inventoryItemType} is not supported.`);
  }
};
exports.Layout = Layout;