"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleOptionsContext = exports.useWaffleOptions = exports.WaffleOptionsProvider = exports.WaffleOptions = exports.DEFAULT_WAFFLE_OPTIONS_STATE = exports.DEFAULT_LEGEND = void 0;
var _react = require("react");
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _constate = _interopRequireDefault(require("constate"));
var _inventory_views = require("../../../../../common/inventory_views");
var _use_alert_prefill = require("../../../../alerting/use_alert_prefill");
var _use_url_state = require("../../../../utils/use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LEGEND = {
  palette: 'cool',
  steps: 10,
  reverseColors: false
};
exports.DEFAULT_LEGEND = DEFAULT_LEGEND;
const DEFAULT_WAFFLE_OPTIONS_STATE = {
  metric: {
    type: 'cpu'
  },
  groupBy: [],
  nodeType: 'host',
  view: 'map',
  customOptions: [],
  boundsOverride: {
    max: 1,
    min: 0
  },
  autoBounds: true,
  accountId: '',
  region: '',
  customMetrics: [],
  legend: DEFAULT_LEGEND,
  source: 'default',
  sort: {
    by: 'name',
    direction: 'desc'
  },
  timelineOpen: false
};
exports.DEFAULT_WAFFLE_OPTIONS_STATE = DEFAULT_WAFFLE_OPTIONS_STATE;
const useWaffleOptions = () => {
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: DEFAULT_WAFFLE_OPTIONS_STATE,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: 'waffleOptions'
  });
  const [state, setState] = (0, _react.useState)(urlState);
  (0, _react.useEffect)(() => setUrlState(state), [setUrlState, state]);
  const changeMetric = (0, _react.useCallback)(metric => setState(previous => ({
    ...previous,
    metric
  })), [setState]);
  const changeGroupBy = (0, _react.useCallback)(groupBy => setState(previous => ({
    ...previous,
    groupBy
  })), [setState]);
  const changeNodeType = (0, _react.useCallback)(nodeType => setState(previous => ({
    ...previous,
    nodeType
  })), [setState]);
  const changeView = (0, _react.useCallback)(view => setState(previous => ({
    ...previous,
    view: view
  })), [setState]);
  const changeCustomOptions = (0, _react.useCallback)(customOptions => setState(previous => ({
    ...previous,
    customOptions
  })), [setState]);
  const changeAutoBounds = (0, _react.useCallback)(autoBounds => setState(previous => ({
    ...previous,
    autoBounds
  })), [setState]);
  const changeBoundsOverride = (0, _react.useCallback)(boundsOverride => setState(previous => ({
    ...previous,
    boundsOverride
  })), [setState]);
  const changeAccount = (0, _react.useCallback)(accountId => setState(previous => ({
    ...previous,
    accountId
  })), [setState]);
  const changeRegion = (0, _react.useCallback)(region => setState(previous => ({
    ...previous,
    region
  })), [setState]);
  const changeCustomMetrics = (0, _react.useCallback)(customMetrics => {
    setState(previous => ({
      ...previous,
      customMetrics
    }));
  }, [setState]);
  const changeLegend = (0, _react.useCallback)(legend => {
    setState(previous => ({
      ...previous,
      legend
    }));
  }, [setState]);
  const changeSort = (0, _react.useCallback)(sort => {
    setState(previous => ({
      ...previous,
      sort
    }));
  }, [setState]);
  const {
    inventoryPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  (0, _react.useEffect)(() => {
    const {
      setNodeType,
      setMetric,
      setCustomMetrics
    } = inventoryPrefill;
    setNodeType(state.nodeType);
    setMetric(state.metric);
    setCustomMetrics(state.customMetrics);
  }, [state, inventoryPrefill]);
  const changeTimelineOpen = (0, _react.useCallback)(timelineOpen => setState(previous => ({
    ...previous,
    timelineOpen
  })), [setState]);
  return {
    ...DEFAULT_WAFFLE_OPTIONS_STATE,
    ...state,
    changeMetric,
    changeGroupBy,
    changeNodeType,
    changeView,
    changeCustomOptions,
    changeAutoBounds,
    changeBoundsOverride,
    changeAccount,
    changeRegion,
    changeCustomMetrics,
    changeLegend,
    changeSort,
    changeTimelineOpen,
    setWaffleOptionsState: setState
  };
};
exports.useWaffleOptions = useWaffleOptions;
const encodeUrlState = state => {
  return _inventory_views.inventoryOptionsStateRT.encode(state);
};
const decodeUrlState = value => {
  const state = (0, _pipeable.pipe)(_inventory_views.inventoryOptionsStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
  if (state) {
    state.source = 'url';
  }
  return state;
};
const WaffleOptions = (0, _constate.default)(useWaffleOptions);
exports.WaffleOptions = WaffleOptions;
const [WaffleOptionsProvider, useWaffleOptionsContext] = WaffleOptions;
exports.useWaffleOptionsContext = useWaffleOptionsContext;
exports.WaffleOptionsProvider = WaffleOptionsProvider;