"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotContainer = void 0;
var _metrics_source = require("../../../../containers/metrics_source");
var _use_snaphot = require("../hooks/use_snaphot");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _use_waffle_time = require("../hooks/use_waffle_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotContainer = ({
  render
}) => {
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const {
    metric,
    groupBy,
    nodeType,
    accountId,
    region,
    view
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQueryAsJson
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const {
    loading,
    nodes,
    reload,
    interval = '60s'
  } = (0, _use_snaphot.useSnapshot)({
    filterQuery: filterQueryAsJson,
    metrics: [metric],
    groupBy,
    nodeType,
    sourceId,
    currentTime,
    accountId,
    region,
    sendRequestImmediately: false,
    includeTimeseries: view === 'table'
  }, {
    abortable: true
  });
  return render({
    loading,
    nodes,
    reload,
    interval
  });
};
exports.SnapshotContainer = SnapshotContainer;