"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _kubernetes_tour = require("./kubernetes_tour");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ButtonLabel = ({
  label,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  style: {
    padding: 12,
    background: theme === null || theme === void 0 ? void 0 : theme.eui.euiFormInputGroupLabelBackground,
    fontSize: '0.75em',
    fontWeight: 600,
    color: theme === null || theme === void 0 ? void 0 : theme.eui.euiTitleColor
  }
}, label);
const DropdownButton = (0, _common.withTheme)(props => {
  const {
    onClick,
    label,
    theme,
    children,
    showKubernetesInfo
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    style: {
      border: theme === null || theme === void 0 ? void 0 : theme.eui.euiFormInputGroupBorder,
      boxShadow: `0px 3px 2px ${theme === null || theme === void 0 ? void 0 : theme.eui.euiTableActionsBorderColor}, 0px 1px 1px ${theme === null || theme === void 0 ? void 0 : theme.eui.euiTableActionsBorderColor}`
    }
  }, showKubernetesInfo ? /*#__PURE__*/_react.default.createElement(_kubernetes_tour.KubernetesTour, null, /*#__PURE__*/_react.default.createElement(ButtonLabel, {
    label: label,
    theme: theme
  })) : /*#__PURE__*/_react.default.createElement(ButtonLabel, {
    label: label,
    theme: theme
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": props['data-test-subj'],
    color: "text",
    iconType: "arrowDown",
    onClick: onClick,
    iconSide: "right",
    size: "xs"
  }, children)));
});
exports.DropdownButton = DropdownButton;