"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_COLUMN_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_COLUMN_LABEL = {
  title: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.nameColumnHeader', {
    defaultMessage: 'Name'
  }),
  cpuUsage: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.cpuUsageColumnHeader', {
    defaultMessage: 'CPU usage (avg.)'
  }),
  diskSpaceUsage: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.diskUsageColumnHeader', {
    defaultMessage: 'Disk Usage (avg.)'
  }),
  tx: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.txColumnHeader', {
    defaultMessage: 'TX (avg.)'
  }),
  rx: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.rxColumnHeader', {
    defaultMessage: 'RX (avg.)'
  }),
  memoryFree: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.memoryFreeColumnHeader', {
    defaultMessage: 'Memory Free (avg.)'
  }),
  memoryUsage: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.memoryUsageColumnHeader', {
    defaultMessage: 'Memory Usage (avg.)'
  }),
  normalizedLoad1m: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.normalizedLoad1mColumnHeader', {
    defaultMessage: 'Normalized Load (avg.)'
  }),
  toggleDialogAction: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.toggleDialogWithDetails', {
    defaultMessage: 'Toggle dialog with details'
  })
};
exports.TABLE_COLUMN_LABEL = TABLE_COLUMN_LABEL;