"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_boolean = require("../../../../../hooks/use_boolean");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectedHostsLabel = selectedHostsCount => {
  return _i18n.i18n.translate('xpack.infra.hostsViewPage.table.selectedHostsButton', {
    values: {
      selectedHostsCount
    },
    defaultMessage: 'Selected {selectedHostsCount} {selectedHostsCount, plural, =1 {host} other {hosts}}'
  });
};
const FilterAction = ({
  selectedItemsCount,
  filterSelectedHosts
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _use_boolean.useBoolean)(false);
  const onAddFilterClick = () => {
    filterSelectedHosts();
    closePopover();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _css.css)`
        position: relative;
        height: ${euiTheme.size.m};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    "data-test-subj": "bulkAction",
    panelPaddingSize: "s",
    className: (0, _css.cx)({
      [(0, _css.css)`
            top: -${euiTheme.size.s};
            position: absolute;
            opacity: 0;
            visibility: hidden;
          `]: true,
      [(0, _css.css)`
            opacity: 1;
            ${_eui.euiCanAnimate} {
              transition: opacity ${euiTheme.animation.extraFast} ease-in;
            }
            visibility: visible;
          `]: selectedItemsCount > 0
    }),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "hostsViewTableSelectHostsFilterButton",
      size: "xs",
      flush: "left",
      iconSide: "right",
      iconType: "arrowDown",
      onClick: togglePopover
    }, selectedHostsLabel(selectedItemsCount))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "hostsViewTableAddFilterButton",
    iconType: "filter",
    onClick: onAddFilterClick
  }, _i18n.i18n.translate('xpack.infra.hostsViewPage.table.addFilter', {
    defaultMessage: 'Add filter'
  }))));
};
exports.FilterAction = FilterAction;