"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostCountKpi = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _visualizations = require("../../../../../common/visualizations");
var _use_host_count = require("../../hooks/use_host_count");
var _use_unified_search = require("../../hooks/use_unified_search");
var _metric_chart_wrapper = require("../chart/metric_chart_wrapper");
var _lens = require("../../../../../components/lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostCountKpi = ({
  height
}) => {
  var _hostCountData$count$2;
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const {
    data: hostCountData,
    isRequestRunning: hostCountLoading
  } = (0, _use_host_count.useHostCountContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const euiTheme = (0, _public.useTheme)();
  const {
    value: formulas
  } = (0, _useAsync.default)(() => inventoryModel.metrics.getFormulas());
  const hostsCountChart = {
    id: 'hostsViewKPI-hostsCount',
    color: euiTheme.eui.euiColorLightestShade,
    title: _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.hostCount.title', {
      defaultMessage: 'Hosts'
    })
  };
  const getSubtitle = () => {
    var _hostCountData$count$;
    return searchCriteria.limit < ((_hostCountData$count$ = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$ !== void 0 ? _hostCountData$count$ : 0) ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.hostCount.limit', {
      defaultMessage: 'Limited to {limit}',
      values: {
        limit: searchCriteria.limit
      }
    }) : undefined;
  };
  return /*#__PURE__*/_react.default.createElement(_metric_chart_wrapper.MetricChartWrapper, (0, _extends2.default)({}, hostsCountChart, {
    style: {
      height
    },
    value: (_hostCountData$count$2 = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$2 !== void 0 ? _hostCountData$count$2 : 0,
    subtitle: getSubtitle(),
    toolTip: /*#__PURE__*/_react.default.createElement(_lens.TooltipContent, {
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.hostCount.value,
      description: _visualizations.METRICS_TOOLTIP.hostCount
    }),
    loading: hostCountLoading
  }));
};
exports.HostCountKpi = HostCountKpi;