"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricChartWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lens = require("../../../../../components/lens");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricChartWrapper = /*#__PURE__*/_react.default.memo(({
  color,
  extra,
  id,
  loading,
  value,
  subtitle,
  title,
  toolTip,
  style,
  ...props
}) => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const loadedOnce = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (!loadedOnce.current && !loading) {
      loadedOnce.current = true;
    }
    return () => {
      loadedOnce.current = false;
    };
  }, [loading]);
  const metricsData = {
    title,
    subtitle,
    color,
    extra,
    value,
    valueFormatter: d => d.toString()
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({}, props, {
    hasShadow: false,
    paddingSize: "none",
    "data-test-subj": id
  }), loading && !loadedOnce.current ? /*#__PURE__*/_react.default.createElement(_lens.ChartPlaceholder, {
    style: style
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: "eui-fullWidth",
    delay: "regular",
    content: toolTip,
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: style,
    css: (0, _react2.css)`
                .echMetric {
                  border-radius: ${euiTheme.euiTheme.border.radius.medium};
                  pointer-events: none;
                }
              `
  }, /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: id,
    data: [[metricsData]]
  }))));
});
exports.MetricChartWrapper = MetricChartWrapper;